<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="createFieldSummaryTable">
		<xsl:param name="title"/>
		<xsl:param name="nodeSet"/>
		<xsl:param name="classpath"/>
		<a name="field_summary"></a>
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
			<xsl:for-each select="$nodeSet">
				<xsl:sort select="@elementName" />
				<xsl:variable name="description">
					<xsl:apply-templates select="current()" mode="getDescription"/>
				</xsl:variable>
				<xsl:variable name="elName" select="@elementName"/>
				<tr class="TableRow">
					<td align="right" valign="top" width="20%">
					
					<xsl:variable name="typeName">
						<xsl:call-template name="typeRefHandler">
							<xsl:with-param name="parameter" select="current()"></xsl:with-param>
						</xsl:call-template>
					</xsl:variable>
						<font size="-1"><code>
						&amp;nbsp; <xsl:value-of select="@visibility"/>&amp;nbsp; 
						<b>
						<xsl:value-of select="$typeName"/>
						</b></code>
						</font>
					</td>
					<td>
						<code><b>
							<a href="{$classpath}#{$elName}">
								<xsl:value-of select="$elName"/>
							</a>						
						</b></code>
						<br/><xsl:text>&#x9;</xsl:text>
						<xsl:choose>
							<xsl:when test="string-length($description) &gt; 0">
								<xsl:value-of select="Property[@name='description']"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>&#xA0;</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		<p/>
	</xsl:template>
	
	<!-- Creates inherited fields table -->
	<xsl:template name="InheritedFields">
		<xsl:param name="class"></xsl:param>
		<xsl:param name="thisNode"></xsl:param>
		
		<xsl:variable name="inheritances" select="$class/Extends | $class/Implements"></xsl:variable>
		<xsl:for-each select="$inheritances">
			<xsl:variable name="item" select="key('classifier', current()/@idref)"></xsl:variable>
			<xsl:variable name="containsNode">
				<xsl:call-template name="searchFor">
					<xsl:with-param name="where" select="$thisNode"></xsl:with-param>
					<xsl:with-param name="what" select="$item"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:if test="string-length($containsNode) = 0">
				<xsl:call-template name="InheritedFields">
					<xsl:with-param name="class" select="$item"></xsl:with-param>
					<xsl:with-param name="thisNode" select="$thisNode | $item"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>	
			
			<xsl:variable name="fields" select="$item/Field[(@fieldType='Field') and not(@visibility='private')]"></xsl:variable>
			<xsl:if test="$fields">
				
				<!-- Heading -->
				<table border="1" cellpadding="3" cellspacing="0" width="100%">
				<tr class="TableSubHeader">
				<td>
				<b>
				
				<xsl:variable name="reff">
					<xsl:apply-templates select="$item" mode="HRefWithImgLoad"/>
				</xsl:variable>
				
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Fields_inherited_from'"/>
					<!--xsl:with-param name="p1" select="$item/@type"/-->
					<xsl:with-param name="p1">
						<xsl:call-template name="getLocalizedClassType">
							<xsl:with-param name="type" select="$item/@type"/>
						</xsl:call-template>
					</xsl:with-param>
					<xsl:with-param name="p2" select="$reff"/>
				</xsl:call-template>
			
				<!--xsl:text> </xsl:text>					
				<xsl:apply-templates select="$item" mode="HRefWithImgLoad"/-->
				</b>
				</td>
				</tr>

				<!-- Contents -->
				<tr class="TableRow">
				<td><code>
				<xsl:for-each select="$fields">
					<xsl:sort select="@elementName"></xsl:sort>

					<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>

					<!-- xsl:if test="not(position()=last())" (didn't work when sorting)-->
						<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
					<!-- /xsl:if -->

				</xsl:for-each>
				</code></td>
				</tr>				

				</table>
				<p/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>
